<?php
session_start();

header('Content-Type: application/json');

if (!isset($_SESSION['admin']) || $_SESSION['admin'] !== true) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

if (!isset($_POST['floor'], $_POST['quarter'], $_POST['br'], $_POST['status'])) {
    echo json_encode(['success' => false, 'message' => 'Missing parameters']);
    exit;
}

$floor = (int)$_POST['floor'];
$quarter = (int)$_POST['quarter'];
$br = (int)$_POST['br'];
$status = (int)$_POST['status'];

if ($br !== 1 && $br !== 2) {
    echo json_encode(['success' => false, 'message' => 'Invalid BR number']);
    exit;
}
if ($status < 0 || $status > 2) {
    echo json_encode(['success' => false, 'message' => 'Invalid status']);
    exit;
}

try {
    $db = new SQLite3('quarters.db');
    $field = $br === 1 ? 'br1_status' : 'br2_status';
    $stmt = $db->prepare("UPDATE quarters SET $field = :status WHERE floor = :floor AND quarter = :quarter");
    $stmt->bindValue(':status', $status, SQLITE3_INTEGER);
    $stmt->bindValue(':floor', $floor, SQLITE3_INTEGER);
    $stmt->bindValue(':quarter', $quarter, SQLITE3_INTEGER);
    $stmt->execute();

    if ($db->changes() > 0) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'No changes made']);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
